#include <bits/stdc++.h>
#define ll long long
using namespace std;

const int MAXN = 2 * 1e5 + 5;
int N, K;
ll A[MAXN], B[MAXN], sol;
bool XOR = 1, AND = 1;

struct trieNode
{
    ll v;
    trieNode *A[2];
};

trieNode *newNode()
{
    trieNode *temp = new trieNode;
    temp->v = 0;
    temp->A[0] = NULL;
    temp->A[1] = NULL;
    return temp;
}

void Insert(trieNode *root, ll pre, ll bits)
{
    trieNode *temp = root;
    bool v;
    for(ll i = bits; i >= 0; i--)
    {
        v = pre & (1 << i);
        if(temp->A[v] == NULL) temp->A[v] = newNode();
        temp = temp->A[v];
    }
    temp->v = pre;
}

ll XorQuery(trieNode *root, ll pre, ll bits)
{
    trieNode *temp = root;
    bool v;
    for(ll i = bits; i >= 0; i--)
    {
        v = pre & (1 << i);
        if(temp->A[!v] != NULL) temp = temp->A[!v];
        else if(temp->A[v] != NULL) temp = temp->A[v];
    }
    return pre ^ (temp->v);
}

ll MaxSub(int l, int r)
{
    ll maxv = 0;
    for(int i = l; i <= r; i++) maxv = max(maxv, A[i]);
    ll bits = 64 - __builtin_clzll(maxv | 1);
    trieNode *root = newNode();
    Insert(root, 0, bits);
    ll ret = 0, pre = 0;
    for(ll i = l; i <= r; i++)
    {
        pre ^= A[i];
        Insert(root, pre, bits);
        ret = max(ret, XorQuery(root, pre, bits));
    }
    return ret;
}

void Set1()
{
    for(int i = 1; i <= N; i++)
    {
        ll pre_xor = 0;
        ll pre_and = B[i];
        for(int j = i; j <= N; j++)
        {
            pre_xor ^= A[j];
            pre_and &= B[j];
            sol = max(sol, pre_xor * pre_and);
        }
    }

    return;
}

void Set2()
{
    for(int i = 1; i <= N; i++) sol = max(sol, B[i]);
    return;
}

void Set4()
{
    sol = MaxSub(1, N);
    return;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cin >> N;
    for(int i = 1; i <= N; i++)
    {
        cin >> A[i];
        if(A[i] != 1) XOR = false;
    }
    for(int i = 1; i <= N; i++)
    {
        cin >> B[i];
        if(B[i] != 1) AND = false;
    }
    if(N <= 2000) Set1();
    if(XOR) Set2();
    if(AND) Set4();
    else Set1();
    cout << sol << "\n";

    return 0;
}